#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "gpdef.h"
#include "gpstdio.h"
#include "gpstdlib.h"
#include "gpgraphic.h"
#include "gpfont.h"
#include "gpmem.h"
#include "gp32_frontend_list.h"
#include "gp32_frontend.h"

int LaunchMame(const char* lpszAppPath, const char* lpszArguments)
{
	char command[256];
	ERR_CODE result;
	F_HANDLE fHandle;

	unsigned long dwDummy;
	unsigned long dwHeader, dwFileLength, dwInfoLength;

	int    i, j, k;
	int    n_read, n_axf_ro, n_axf_rw;
	unsigned char *p_axf,  *p_axf_ro, *p_axf_rw;
	unsigned char *p_work, *p_temp;

	
	result = GpFileOpen(lpszAppPath, OPEN_R, &fHandle);
	if (result != SM_OK)
		return -2;

	GpFileRead(fHandle, &dwHeader,     sizeof(unsigned long), &dwDummy);
	GpFileRead(fHandle, &dwFileLength, sizeof(unsigned long), &dwDummy);
	GpFileRead(fHandle, &dwInfoLength, sizeof(unsigned long), &dwDummy);

	GpFileSeek(fHandle, FROM_BEGIN, dwInfoLength + 8, (long *) &dwDummy);

	GpFileRead(fHandle, &n_axf_ro, sizeof(int), &dwDummy);
	GpFileRead(fHandle, &n_axf_rw, sizeof(int), &dwDummy);

	n_read = n_axf_ro + n_axf_rw;
	p_axf = (unsigned char*) gm_malloc(n_read + 4);
	if (!p_axf)
	{
		GpFileClose(fHandle);
		return -1;
	}

	p_axf_ro = p_axf + 4;
	p_axf_rw = p_axf_ro + n_axf_ro;
	*(int*) p_axf = n_read;

	GpFileRead(fHandle, p_axf_rw, n_axf_rw, &dwDummy);

	j = n_axf_rw;
	p_work = p_axf_rw;
	for (i = 0; i < j; i ++)
	{
		*p_work ^= 0xff;
		p_work ++;
	}


	GpFileRead(fHandle, p_axf_ro, n_axf_ro, &dwDummy);
	GpFileClose(fHandle);

	j = n_axf_ro;
	k = n_axf_rw;
	p_work = p_axf_ro;
	p_temp = p_axf_rw;
	for (i = 0; i < j; i ++)
	{
		*p_work ^= *p_temp;
		p_work ++;
		p_temp ++;
		if (p_temp >= (p_axf_rw + k))
		p_temp = p_axf_rw;
	}

	p_work = (unsigned char*) lpszAppPath;
	while (*p_work)
		p_work ++;
	while (*p_work != '.')
		p_work --;
	*p_work = 0;


	GpClockSpeedChange (67800000, 0x69032, 3);
	
	gm_strcpy( command, lpszAppPath );
	gm_strcat( command, " " );
	gm_strcat( command, lpszArguments );

	return GpAppExecute((char*) p_axf, (const char*) command);
}

void GpMain(void *arg)
{
	char text[128];
	char fxe[128];
	char arguments[1024];
	char thisApp[128];
	int i, ret;
	int length = 1024;
	GP_PALETTEENTRY colorgp;

	/* Try to load any passed in arguments */
	char* appPath = GpAppPathGet(&length);
	sscanf(appPath, "%s %s", thisApp, romName_argument);

	/* SMC Access Init */
	GpFatInit();

	/* Clock Speed 133 mhz */
	GpClockSpeedChange(132000000, 0x3a011, 3);

	/* GP32 Video Init */
	GpGraphicModeSet(8,0);  /* 320x240, 256 colors */
	for( i=0; i<2; i++ ) {
		GpLcdSurfaceGet( &gpDraw[i],i );
		GpRectFill( NULL, &gpDraw[i],0,0,gpDraw[i].buf_w,gpDraw[i].buf_h,0x0 );
	}
	nflip=0;
	GpSurfaceSet( &gpDraw[nflip] );
	GpLcdEnable();
	GpSurfaceFlip( &gpDraw[nflip] );

	/* Show Intro Screen */
	GpRectFill( NULL, &gpDraw[0],0,0,gpDraw[0].buf_w,gpDraw[0].buf_h,0x0 );
	GpRectFill( NULL, &gpDraw[1],0,0,gpDraw[1].buf_w,gpDraw[1].buf_h,0x0 );
	for (i=0;i<256;i++)
		gpPalette[i]=gp32splash_Pal[i];
	GpBitBlt( NULL, &gpDraw[nflip],0,0,gpDraw[nflip].buf_w,gpDraw[nflip].buf_h,(unsigned char*)gp32splash,0,0,gp32splash_width,gp32splash_height);

	/* Initialize Game Listings */
	load_game_list();

	/* Select Game */
	select_game();

	/* Restore MAME Palette */
	GpRectFill( NULL, &gpDraw[0],0,0,gpDraw[0].buf_w,gpDraw[0].buf_h,0x0 );
	GpRectFill( NULL, &gpDraw[1],0,0,gpDraw[1].buf_w,gpDraw[1].buf_h,0x0 );
	colorgp = RGBA(0,0,0,0);
	for (i=0;i<256;i++)
		gpPalette[i]=colorgp;
	colorgp = RGBA(255,255,255,0);
	gpPalette[1]=colorgp;

	/* Set Log Messages start at row 0 */
	gp32_gamelist_zero();

#ifndef USE_DRZ80
	if (gm_compare(drivers[game_index].fxe, "mdeast16")==0)
		sprintf(text,"Calling \"mamegp32\\%s.fxe\"",drivers[game_index].fxe);
	else
		sprintf(text,"Calling \"mamegp32\\%s.fxe\"",drivers[game_index].fxe);
#else
	sprintf(text,"Calling \"mamegp32\\drz80\\%s.fxe\"",drivers[game_index].fxe);
#endif
	gp32_text_log(text);
	sprintf(text,"to load \"mamegp32\\roms\\%s\"", drivers[game_index].name);
	gp32_text_log(text);

	/* Application and arguments to run */
#ifndef USE_DRZ80
	if (gm_compare(drivers[game_index].fxe, "mdeast16")==0)
	{
		sprintf(fxe,"gp:\\gpmm\\mamegp32\\%s.fxe\0",drivers[game_index].fxe);
		sprintf(arguments,"gp:\\gpmm\\mamegp32.fxe %s", drivers[game_index].name);
	}
	else
	{
		sprintf(fxe,"gp:\\gpmm\\mamegp32\\%s.fxe\0",drivers[game_index].fxe);
		sprintf(arguments,"gp:\\gpmm\\mamegp32.fxe %s", drivers[game_index].name);
	}
#else
	sprintf(fxe,"gp:\\gpmm\\mamegp32\\drz80\\%s.fxe\0",drivers[game_index].fxe);
	sprintf(arguments,"gp:\\gpmm\\mamegpdr.fxe %s", drivers[game_index].name);
#endif

	/* Launch Executable with Arguments */
	ret=LaunchMame((const char *)fxe, arguments);

	if(ret == -2)
	{
		gp32_text_log("Unable to open...");
		gp32_text_log(fxe);
	}
	else if(ret == -1)
	{
		gp32_text_log("Out of memory opening...");
		gp32_text_log(fxe);
		{char sMsg[64];gm_sprintf(sMsg, "Avail: %d", gm_availablesize());gp32_text_log(sMsg);}
	}

	while(1);
}
